/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.inventory.fluid;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.fluids.FluidStack;

public class FluidInventory {
    private static final String NBT_SLOT = "Slot_%d";
    private final FluidStack[] fluids;
    private final int maxAmount;

    public FluidInventory(int size, int maxAmount) {
        this.fluids = new FluidStack[size];
        for (int i = 0; i < size; ++i) {
            this.fluids[i] = FluidStack.EMPTY;
        }
        this.maxAmount = maxAmount;
    }

    public FluidInventory(int size) {
        this(size, Integer.MAX_VALUE);
    }

    public int getSlots() {
        return this.fluids.length;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public FluidStack[] getFluids() {
        return this.fluids;
    }

    @Nonnull
    public FluidStack getFluid(int slot) {
        return this.fluids[slot];
    }

    public void setFluid(int slot, @Nonnull FluidStack stack) {
        if (stack.getAmount() > this.maxAmount) {
            throw new IllegalArgumentException("Fluid size is invalid (given: " + stack.getAmount() + ", max size: " + this.maxAmount + ")");
        }
        this.fluids[slot] = stack;
        this.onContentsChanged();
    }

    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < this.getSlots(); ++i) {
            FluidStack stack = this.getFluid(i);
            if (stack.isEmpty()) continue;
            tag.m_128365_(String.format(NBT_SLOT, i), (Tag)stack.writeToNBT(new CompoundTag()));
        }
        return tag;
    }

    public void readFromNbt(CompoundTag tag) {
        for (int i = 0; i < this.getSlots(); ++i) {
            String key = String.format(NBT_SLOT, i);
            if (!tag.m_128441_(key)) continue;
            this.fluids[i] = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_(key));
        }
    }

    protected void onContentsChanged() {
    }
}

